/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.exception.common.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.MultiPrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import com.lubanops.apm.plugin.exception.common.stats.ExceptionConfig;
import com.lubanops.apm.plugin.exception.common.stats.ExceptionStats;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ExceptionStatsAggregator
extends MultiPrimaryKeyAggregator<ExceptionStats> {
    static String tag_exceptionType = "exceptionType";
    static String tag_className = "className";
    static String tag_logType = "logType";
    public static final String tag_count = "count";
    public static final String tag_message = "message";
    public static final String tag_stackTrace = "stackTrace";

    protected Class<ExceptionStats> getValueType() {
        return ExceptionStats.class;
    }

    protected int primaryKeyLength() {
        return 3;
    }

    public void onError(String exceptionType, String className, String logType, Object m, Throwable th) {
        if (!this.isEnable) {
            return;
        }
        ExceptionStats stats = (ExceptionStats)this.getValue(new String[]{exceptionType, className, logType});
        stats.setErrorTraceId(TraceCollector.getTraceId());
        stats.onLog(m, th);
    }

    public String getName() {
        return "exception";
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    public void parseParameters(Map<String, String> parameters) {
        if (parameters == null) {
            ExceptionConfig.setLogError(true);
            ExceptionConfig.setLogPrintTrace(false);
        } else {
            Boolean logError = (Boolean)ParameterParseUtil.getParameterValue(parameters, (String)"logError", Boolean.class);
            ExceptionConfig.setLogError(logError);
            Boolean logPrintTrace = (Boolean)ParameterParseUtil.getParameterValue(parameters, (String)"logPrintTrace", Boolean.class);
            ExceptionConfig.setLogPrintTrace(logPrintTrace);
        }
    }

    protected List<String> primaryKey() {
        return Arrays.asList(tag_exceptionType, tag_className, tag_logType);
    }
}

