/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.service.message.command;

import com.lubanops.apm.integration.debugger.model.ArthasDebuggerCommand;
import com.lubanops.apm.integration.debugger.service.message.AbstractMessageProvider;
import com.lubanops.apm.integration.debugger.service.message.Requests;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class VmToolCommand
extends AbstractMessageProvider<VmToolCommand> {
    @Override
    public Class<VmToolCommand> getType() {
        return VmToolCommand.class;
    }

    @Override
    public ArthasDebuggerCommand buildArthasCommand(Requests.Arguments commandArguments) {
        Requests.VmToolArguments args = (Requests.VmToolArguments)commandArguments;
        return this.toCommandLine(args);
    }

    private ArthasDebuggerCommand toCommandLine(Requests.VmToolArguments args) {
        StringBuilder sb = new StringBuilder("vmtool --action getInstances -c ");
        if (StringUtils.isBlank((CharSequence)args.getHashClassLoader())) {
            return new ArthasDebuggerCommand("", "hash pattern must have a value", false);
        }
        sb.append(args.getHashClassLoader());
        if (StringUtils.isBlank((CharSequence)args.getClassPattern())) {
            return new ArthasDebuggerCommand("", "Class pattern must have a value", false);
        }
        sb.append(" --className " + args.getClassPattern());
        if (!ObjectUtils.isEmpty((Object)args.getInstanceIndex())) {
            sb.append(" --express 'instances[" + args.getInstanceIndex() + "]");
            if (!StringUtils.isBlank((CharSequence)args.getFiledName())) {
                sb.append("." + args.getFiledName() + "'");
            } else {
                sb.append("'");
            }
        }
        sb.append(" --limit 10");
        return new ArthasDebuggerCommand(sb.toString(), "", true);
    }
}

