/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.service.message.command;

import com.lubanops.apm.integration.debugger.model.ArthasDebuggerCommand;
import com.lubanops.apm.integration.debugger.service.message.AbstractMessageProvider;
import com.lubanops.apm.integration.debugger.service.message.Requests;
import org.apache.commons.lang3.StringUtils;

public class JadCommand
extends AbstractMessageProvider<JadCommand> {
    @Override
    public Class<JadCommand> getType() {
        return JadCommand.class;
    }

    @Override
    public ArthasDebuggerCommand buildArthasCommand(Requests.Arguments commandArguments) {
        Requests.JadArguments args = (Requests.JadArguments)commandArguments;
        return this.toCommandLine(args);
    }

    private ArthasDebuggerCommand toCommandLine(Requests.JadArguments args) {
        StringBuilder sb = new StringBuilder("jad -c ");
        if (StringUtils.isBlank((CharSequence)args.getHashClassLoader())) {
            return new ArthasDebuggerCommand("", "hash pattern must have a value", false);
        }
        sb.append(args.getHashClassLoader());
        if (StringUtils.isBlank((CharSequence)args.getClassPattern())) {
            return new ArthasDebuggerCommand("", "Class pattern must have a value", false);
        }
        sb.append(" " + args.getClassPattern());
        if (StringUtils.isBlank((CharSequence)args.getMethodPattern())) {
            return new ArthasDebuggerCommand("", "Method pattern must have a value", false);
        }
        sb.append(" " + args.getMethodPattern());
        return new ArthasDebuggerCommand(sb.toString(), "", true);
    }
}

