/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.service.job;

import com.huawei.cloud.profiler.pap.v1.PDebuggerRequest;
import com.huawei.cloud.profiler.pap.v1.PDebuggerResponse;
import com.lubanops.apm.integration.debugger.converters.ArthasModelToPDebuggerConverter;
import com.lubanops.apm.integration.debugger.converters.MethodModelToPDebuggerResponseConverter;
import com.lubanops.apm.integration.debugger.handler.DebuggerCommandHandler;
import com.lubanops.apm.integration.debugger.model.ArthasDebuggerCommand;
import com.lubanops.apm.integration.debugger.service.job.AbstractJob;
import com.lubanops.apm.integration.debugger.service.job.CommandType;
import com.lubanops.apm.integration.debugger.service.message.Requests;
import com.lubanops.apm.integration.debugger.service.message.command.SearchMethodCommand;
import com.taobao.arthas.core.command.model.ResultModel;
import com.taobao.arthas.core.command.model.SearchMethodModel;
import com.taobao.arthas.core.command.model.StatusModel;
import com.taobao.arthas.core.distribution.PackingResultDistributor;
import com.taobao.arthas.core.distribution.impl.PackingResultDistributorImpl;
import com.taobao.arthas.core.shell.session.Session;
import java.util.HashSet;

public class MethodsJob
extends AbstractJob {
    private DebuggerCommandHandler debugCommandHandler;
    private Session session;
    private SearchMethodCommand searchMethodCommand;

    public MethodsJob(DebuggerCommandHandler debuggerCommandHandler) {
        this.debugCommandHandler = debuggerCommandHandler;
        this.session = this.debugCommandHandler.getSession();
        this.searchMethodCommand = new SearchMethodCommand();
    }

    @Override
    public CommandType getType() {
        return CommandType.SEARCH_METHOD_COMMAND;
    }

    @Override
    public PDebuggerResponse handleRequest(PDebuggerRequest request) {
        PackingResultDistributorImpl packingResultDistributor = new PackingResultDistributorImpl(this.session);
        Requests.SearchMethodArguments args = new Requests.SearchMethodArguments();
        args.setClassPattern(request.getPayload().getSearchMethodCommand().getClassPattern());
        args.setMethodPattern(request.getPayload().getSearchMethodCommand().getMethodPattern());
        ArthasDebuggerCommand arthasDebuggerCommand = this.searchMethodCommand.buildArthasCommand(args);
        if (!arthasDebuggerCommand.getSuccess().booleanValue()) {
            return ArthasModelToPDebuggerConverter.createFailureResponse(request, new StatusModel(1, arthasDebuggerCommand.getErrorMsg()), false);
        }
        Boolean expired = this.debugCommandHandler.handle(arthasDebuggerCommand.getCommand(), (PackingResultDistributor)packingResultDistributor);
        HashSet<SearchMethodModel> searchMethodModels = new HashSet<SearchMethodModel>();
        StatusModel statusModel = null;
        for (ResultModel result : packingResultDistributor.getResults()) {
            if (result instanceof SearchMethodModel) {
                searchMethodModels.add((SearchMethodModel)result);
                continue;
            }
            if (!(result instanceof StatusModel)) continue;
            statusModel = (StatusModel)result;
        }
        if (searchMethodModels.isEmpty()) {
            if (statusModel != null && statusModel.getStatusCode() == 0) {
                statusModel = new StatusModel(-1, "Empty Response");
            }
            return ArthasModelToPDebuggerConverter.createFailureResponse(request, statusModel, expired);
        }
        return MethodModelToPDebuggerResponseConverter.convert(searchMethodModels, request);
    }

    @Override
    public boolean needReset() {
        return false;
    }
}

