/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.mqtt.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultExceptionAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultVersionAggregator;
import com.lubanops.apm.bootstrap.plugin.mqtt.collector.MqttClientPublishAggregator;
import com.lubanops.apm.bootstrap.plugin.mqtt.collector.PahoMsgInvocationAggregator;
import java.util.Map;

public class PahoPublisherCollector
extends Collector {
    public static final PahoPublisherCollector INSTANCE = new PahoPublisherCollector();
    public static final PahoMsgInvocationAggregator MESSAGE_AGGREGATOR = new PahoMsgInvocationAggregator();
    public static final MqttClientPublishAggregator CLIENT_PUBLISH_AGGREGATOR = new MqttClientPublishAggregator();
    public static final DefaultExceptionAggregator EXCEPTION_AGGREGATOR = new DefaultExceptionAggregator();
    public static final DefaultVersionAggregator VERSION_AGGREGATOR = new DefaultVersionAggregator();

    public static Map<String, Object> onSendStartAsync(String serverUri) {
        return MESSAGE_AGGREGATOR.onStartAsync(serverUri, "PUBLISH");
    }

    public static void onSendFinallyAsync(Map<String, Object> map) {
        MESSAGE_AGGREGATOR.onFinallyAsync(map, "PahoPublisher", false);
    }

    public static void onSendErrorAsync(Map<String, Object> map) {
        MESSAGE_AGGREGATOR.onErrorAsync(map);
    }

    public static void onException(Throwable throwable) {
        EXCEPTION_AGGREGATOR.onThrowable(throwable);
    }

    public static void onSendPublishMsg(String clientId, String topic, int bytesCount) {
        CLIENT_PUBLISH_AGGREGATOR.onSendPublishMsg(clientId, topic, bytesCount);
    }

    public static void setVersion(String version) {
        VERSION_AGGREGATOR.setVersion(version);
    }

    public void parseParameter(Map<String, String> parameters) {
    }

    public String getCollectorName() {
        return "PahoPublisher";
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)MESSAGE_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)CLIENT_PUBLISH_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)EXCEPTION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)VERSION_AGGREGATOR);
        INSTANCE.register();
    }
}

