/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.redis.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.NonePrimaryKeyAggregator;
import com.lubanops.apm.plugin.redis.collector.commons.RedisTransformHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class MasterSwitchAggregator
extends NonePrimaryKeyAggregator {
    private static final String JEDIS_AGGREGATE_KEY_JEDIS_CLUSTER = "switch";
    private static final String JEDIS_AGGREGATE_KEY_SWITCH_TIMES = "switchTimes";
    private AtomicLong switchTimes = new AtomicLong(0L);
    private List<String> fromNodes = new ArrayList<String>();
    private List<String> toNodes = new ArrayList<String>();
    private volatile long switchTimesOld;

    public MonitorDataRow constructItemRow() {
        long switchTimesNew = this.switchTimes.get();
        long switchTimesArea = switchTimesNew - this.switchTimesOld;
        MonitorDataRow row = new MonitorDataRow().add("from", (Object)RedisTransformHelper.normalizeList(this.fromNodes)).add("to", (Object)RedisTransformHelper.normalizeList(this.toNodes)).add(JEDIS_AGGREGATE_KEY_SWITCH_TIMES, (Object)switchTimesArea);
        this.switchTimesOld = switchTimesNew;
        return switchTimesArea == 0L ? null : row;
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    public List<MonitorDataRow> harvest() {
        List rows = super.harvest();
        this.toNodes.clear();
        return rows;
    }

    public void clusterSwitch(List<String> to) {
        if (this.fromNodes.isEmpty()) {
            this.fromNodes = to;
        } else if (!this.fromNodes.equals(to)) {
            this.fromNodes = this.toNodes;
            this.toNodes = to;
            this.switchTimes.getAndIncrement();
        }
    }

    public void parseParameters(Map<String, String> parameters) {
    }

    public String getName() {
        return JEDIS_AGGREGATE_KEY_JEDIS_CLUSTER;
    }

    public List<MonitorDataRow> getAllStatus() {
        return null;
    }

    public void clear() {
    }
}

