/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.httpasyncclient.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HttpClientCollector;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.elasticsearch.restclient.collector.EsRestClientCollector;
import com.lubanops.apm.plugin.httpasyncclient.PoolInfoUtils;
import com.lubanops.apm.plugin.httpasyncclient.collector.ApacheHttpAsyncClientCollector;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class ResponseReceivedInterceptor
implements Interceptor {
    private static final int EXPECTED_ERROR_CODE = 400;

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (HttpClientCollector.INSTANCE.isEnable()) {
                TraceCollector.onError((Throwable)e);
                Map map = (Map)((TransformAccess)object).getLopsAttribute();
                Boolean isInEsRequest = (Boolean)map.get("isInEs");
                SpanEvent spanEvent = (SpanEvent)map.get("spanevent");
                if (isInEsRequest != null && isInEsRequest.booleanValue()) {
                    EsRestClientCollector.httpclientOnError((Map)map, (String)spanEvent.getTraceId());
                } else {
                    HttpClientCollector.onThrowableAsync((Throwable)e, (Map)map, (String)spanEvent.getTraceId());
                }
            }
        }
        catch (Exception requestConException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)requestConException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (HttpClientCollector.INSTANCE.isEnable()) {
                Boolean isInEsRequest;
                HttpResponse response = (HttpResponse)args[0];
                Map map = (Map)((TransformAccess)object).getLopsAttribute();
                SpanEvent spanEvent = (SpanEvent)map.get("spanevent");
                String requestUri = (String)map.get("url");
                int responseCode = response.getStatusLine().getStatusCode();
                String envId = null;
                String traceId = null;
                Header[] envIdHeaders = response.getHeaders(Headers.ENV_ID.getValue());
                if (envIdHeaders.length > 0) {
                    envId = envIdHeaders[0].getValue();
                }
                if (spanEvent != null) {
                    traceId = spanEvent.getTraceId();
                    spanEvent.addTag("code", String.valueOf(responseCode));
                    if (responseCode >= 400) {
                        spanEvent.setSpanError(true);
                    }
                    if (ApacheHttpAsyncClientCollector.INSTANCE.isGetPoolInfo()) {
                        PoolInfoUtils.addRoutePoolInfo2Tag(spanEvent, object, false);
                    }
                    TraceCollector.onFinallySpanEvent((SpanEvent)spanEvent);
                }
                if ((isInEsRequest = (Boolean)map.get("isInEs")) == null || !isInEsRequest.booleanValue()) {
                    HttpClientCollector.onResponseCloseAsync((String)envId, (Map)map, (String)traceId);
                    HttpClientCollector.onStatusCodeAsync((String)requestUri, (int)responseCode, (Map)map, (String)traceId);
                } else {
                    EsRestClientCollector.httpclientOnResponseCloseAsync((Map)map, (String)traceId);
                    EsRestClientCollector.onStatusCodeAsync((String)requestUri, (int)responseCode, (Map)map, (String)traceId);
                }
                ((TransformAccess)object).setLopsAttribute(null);
            }
        }
        catch (Exception responseReceived) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)responseReceived);
        }
    }
}

