/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.functiongraph.interceptor;

import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import com.huawei.function.runtime.rpc.generate.LoadRequest;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.api.APIService;
import com.lubanops.apm.bootstrap.api.BootAPI;
import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.functiongraph.interceptor.InitializeFunctionInterceptor;
import com.lubanops.apm.plugin.functiongraph.interceptor.ProcessInvokeInterceptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LoadFunctionInterceptor
implements Interceptor {
    private static final Logger LOGGER = LogFactory.getLogger();
    private static final int REGEX_ENV_COUNT = 2;
    private static final int REGEX_ENV_KEY_INDEX = 1;
    private static final int REGEX_ENV_VALUE_INDEX = 2;
    private ThreadLocal<Long> startTime = new ThreadLocal();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        this.startTime.set(System.currentTimeMillis());
        LoadRequest loadRequest = (LoadRequest)args[0];
        Map<String, String> funcEnvs = this.parseAndSetEnv(loadRequest.getFuncEnvsList());
        if (funcEnvs != null) {
            String enabled = funcEnvs.get("FAAS_TRACE_ENABLE");
            LOGGER.info("FAAS_TRACE_ENABLE:" + enabled);
            if ("false".equals(enabled)) {
                AgentConfigManager.setClosed((boolean)true);
                LOGGER.info("AgentConfigManager setClosed");
                return null;
            }
            String ak = funcEnvs.get("FAAS_TRACE_AK");
            String sk = funcEnvs.get("FAAS_TRACE_SK");
            if (StringUtils.isBlank((String)ak) || StringUtils.isBlank((String)sk)) {
                return null;
            }
            String loadTime = funcEnvs.get("FAAS_LOAD_TIME");
            ProcessInvokeInterceptor.setLoadTime(loadTime);
            String appName = funcEnvs.get("FAAS_FUNCTION_NAME");
            appName = appName.substring(appName.lastIndexOf("@") + 1, appName.length()).replace(":", "_");
            InitializeFunctionInterceptor.setFunctionName(appName);
            String env = funcEnvs.get("FAAS_PROJECT_NAME");
            AgentConfigManager.setMasterAuthAk((String)ak);
            AgentConfigManager.setMasterAuthSk((String)sk);
            IdentityConfigManager.setAppName((String)appName);
            IdentityConfigManager.setEnv((String)env);
            AgentConfigManager.setServerLess((boolean)true);
            BootAPI bootAPI = APIService.getBootApi();
            if (bootAPI != null) {
                bootAPI.start();
                APIService.setBootApi(null);
            }
        }
        return null;
    }

    private Map<String, String> parseAndSetEnv(ProtocolStringList envsList) {
        HashMap<String, String> envMap = new HashMap<String, String>();
        if (envsList != null) {
            List funcEnvList = envsList.asByteStringList();
            this.putEnvToMap(envMap, funcEnvList);
        }
        return envMap;
    }

    private void putEnvToMap(Map<String, String> envMap, List<ByteString> envList) {
        for (ByteString env : envList) {
            String envString = env.toStringUtf8();
            String regEx = "func-([\\w-_.]+)=(.*)";
            Pattern pattern = Pattern.compile(regEx);
            Matcher matcher = pattern.matcher(envString);
            if (!matcher.matches() || matcher.groupCount() != 2) continue;
            envMap.put(matcher.group(1), matcher.group(2));
        }
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        long endTime = System.currentTimeMillis();
        long timeUsed = endTime - this.startTime.get();
        this.startTime.set(null);
        ProcessInvokeInterceptor.setPreloadTime(timeUsed);
    }
}

