/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.interceptor.AsyncLocal;
import com.lubanops.apm.bootstrap.profiler.ClassStackTagType;
import com.lubanops.apm.bootstrap.profiler.ProfilerService;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import java.util.List;

public class ThreadRunInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            List attrList = (List)AsyncLocal.LIST_INHERITABLE_THREAD_LOCAL.get();
            AsyncLocal.LIST_INHERITABLE_THREAD_LOCAL.set(null);
            if (attrList != null) {
                String traceId = (String)attrList.get(0);
                String spanId = (String)attrList.get(1);
                String gtraceId = (String)attrList.get(2);
                List txName = (List)attrList.get(3);
                String userFlag = (String)attrList.get(4);
                String txTag = (String)attrList.get(5);
                String policyId = (String)attrList.get(6);
                String otelTraceId = (String)attrList.get(7);
                String otelSpanId = (String)attrList.get(8);
                if (traceId != null && spanId != null) {
                    StartTraceRequest startTraceRequest = new StartTraceRequest(className, methodName, traceId, spanId, gtraceId);
                    startTraceRequest.setKind("ASYNC_THREAD");
                    startTraceRequest.setSource(methodName + "()");
                    startTraceRequest.setDomainId(String.valueOf(IdentityConfigManager.getDomainId()));
                    startTraceRequest.setRealSource(methodName + "()");
                    startTraceRequest.setPolicyId(policyId);
                    startTraceRequest.setOtelTraceId(otelTraceId);
                    startTraceRequest.setOtelSpanId(otelSpanId);
                    TraceCollector.onStart((StartTraceRequest)startTraceRequest);
                } else if (gtraceId != null) {
                    TraceCollector.G_TRACE_ID_THREAD_LOCAL.set(gtraceId);
                }
                if (userFlag != null) {
                    TraceCollector.USER_FLAG_THREAD_LOCAL.set(userFlag);
                }
                if (TraceCollector.POLICY_ID_THREAD_LOCAL.get() == null && policyId != null) {
                    TraceCollector.POLICY_ID_THREAD_LOCAL.set(policyId);
                }
                if (txName != null) {
                    TransactionCollector.setTxName((List)txName);
                }
                if (txTag != null) {
                    ProfilerService.getInstance().addCallstackTag(ClassStackTagType.API, txTag);
                }
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            TraceCollector.onError((Throwable)e);
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            TraceCollector.G_TRACE_ID_THREAD_LOCAL.set(null);
            TraceCollector.USER_FLAG_THREAD_LOCAL.set(null);
            TraceCollector.POLICY_ID_THREAD_LOCAL.set(null);
            ProfilerService.getInstance().removeCallstackTag(ClassStackTagType.API);
            TransactionCollector.clear();
            Thread t = Thread.currentThread();
            String name = t.getName();
            TraceCollector.addTag((String)"threadName", (String)name);
            TraceCollector.onFinally((int)200);
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }
}

