/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.interceptor.AsyncLocal;
import com.lubanops.apm.bootstrap.profiler.ProfilerService;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import io.opentelemetry.api.trace.Span;
import java.util.Arrays;
import java.util.List;

public class ThreadInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            String threadName = String.valueOf(args[2]);
            if ("Keep-Alive-Timer".equals(threadName)) {
                return null;
            }
            SpanEvent spanEvent = TraceCollector.getSpanEvent();
            if (spanEvent != null && spanEvent.getNextSpanId() != null) {
                return null;
            }
            Boolean bl = AsyncLocal.CONTEXT.get();
            if (bl != null) {
                return null;
            }
            String nextSpanId = null;
            String traceId = null;
            String otelTraceId = null;
            String otelSpanId = null;
            spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"ASYNC_THREAD");
            AsyncLocal.ONSTART.set(Boolean.TRUE);
            if (spanEvent != null) {
                TraceCollector.addTag((String)"RunnableName", (String)threadName);
                traceId = spanEvent.getTraceId();
                nextSpanId = spanEvent.generateNextSpanId();
                if (nextSpanId != null && nextSpanId.length() > 100) {
                    traceId = null;
                    nextSpanId = null;
                }
                if (spanEvent.getOtelSpan() != null) {
                    otelTraceId = TraceCollector.getOtelTraceId((Span)spanEvent.getOtelSpan());
                    otelSpanId = TraceCollector.getOtelSpanId((Span)spanEvent.getOtelSpan());
                }
            }
            List txName = TransactionCollector.getTxName();
            String gtraceId = TraceCollector.getVirtualTraceId();
            String userFlag = TraceCollector.getUserFlag();
            String txTag = ProfilerService.getInstance().getTxTag();
            String policyId = TraceCollector.getPolicyId();
            if (traceId != null || gtraceId != null) {
                AsyncLocal.LIST_INHERITABLE_THREAD_LOCAL.set(Arrays.asList(traceId, nextSpanId, gtraceId, txName, userFlag, txTag, policyId, otelTraceId, otelSpanId));
            }
        }
        catch (Exception exception) {
            LogFactory.getLogger().log(Level.SEVERE, "ThreadInterceptor onStart:", (Throwable)exception);
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            TraceCollector.onError((Throwable)e);
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "ThreadInterceptor onError:", (Throwable)ex);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            String threadName = String.valueOf(args[2]);
            if ("Keep-Alive-Timer".equals(threadName)) {
                return;
            }
            Boolean bl = AsyncLocal.CONTEXT.get();
            if (bl != null) {
                return;
            }
            AsyncLocal.LIST_INHERITABLE_THREAD_LOCAL.set(null);
            if (AsyncLocal.ONSTART.get() != null) {
                AsyncLocal.ONSTART.remove();
                TraceCollector.onFinally();
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "ThreadInterceptor onFinally:", (Throwable)e1);
        }
    }
}

