/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.netty.collector;

import com.lubanops.apm.bootstrap.collector.CollectorManager;
import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultExceptionAggregator;
import com.lubanops.apm.plugin.netty.collector.NettyMemoryAggregator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class NettyMemoryCollector
extends Collector {
    public static final String NETTY = "Netty";
    public static final NettyMemoryCollector INSTANCE = new NettyMemoryCollector();
    private static final NettyMemoryAggregator NETTY_MEMORY_AGGREGATOR = new NettyMemoryAggregator();
    private static final DefaultExceptionAggregator EXCEPTION_AGGREGATOR = new DefaultExceptionAggregator();

    public static NettyMemoryCollector getInstance() {
        return INSTANCE;
    }

    public void parseParameter(Map<String, String> parameters) {
    }

    public String getCollectorName() {
        return NETTY;
    }

    public static void setDirectMemoryCounter(AtomicLong counter, long directMemoryLimit) {
        CollectorManager.addTag((String)NETTY);
        NETTY_MEMORY_AGGREGATOR.setDirectMemoryCounter(counter);
        NETTY_MEMORY_AGGREGATOR.setDirectMemoryLimit(directMemoryLimit);
    }

    public static void onThrowable(Throwable t) {
        EXCEPTION_AGGREGATOR.onThrowable(t);
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)NETTY_MEMORY_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)EXCEPTION_AGGREGATOR);
        INSTANCE.register();
    }
}

