/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq.consumer.collector;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.collector.api.AbstractAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.rocketmq.RocketMqClientHolder;
import com.lubanops.apm.plugin.rocketmq.RocketMqPidMapper;
import com.lubanops.apm.plugin.rocketmq.RocketMqUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.rocketmq.client.impl.consumer.ConsumeMessageService;
import org.apache.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;

public class RocketMqConsumeServicePoolAggregator
extends AbstractAggregator {
    public List<MonitorDataRow> getAllStatus() {
        ArrayList<MonitorDataRow> result = new ArrayList<MonitorDataRow>();
        List<ConsumeMessageService> serviceList = RocketMqClientHolder.getAllConsumeMessageServices();
        for (ConsumeMessageService service : serviceList) {
            MonitorDataRow row = this.buildRow(service);
            result.add(row);
        }
        return result;
    }

    public MonitorDataRow getStatus(Map<String, String> primaryKeyMap) {
        String clientId = primaryKeyMap.get("clientId");
        String group = primaryKeyMap.get("group");
        if (clientId == null || group == null) {
            return null;
        }
        List<ConsumeMessageService> serviceList = RocketMqClientHolder.getAllConsumeMessageServices();
        for (ConsumeMessageService service : serviceList) {
            MonitorDataRow row = this.buildRow(service);
            if (!clientId.equals(row.get((Object)"clientId")) || !group.equals("group")) continue;
            return row;
        }
        return null;
    }

    private MonitorDataRow buildRow(ConsumeMessageService service) {
        MonitorDataRow row = new MonitorDataRow();
        Object[] attributes = ((AttributeAccess)service).getLopsFileds();
        DefaultMQPushConsumerImpl consumerImp = (DefaultMQPushConsumerImpl)attributes[0];
        String clientId = RocketMqUtils.getClientId(consumerImp);
        String group = (String)attributes[3];
        BlockingQueue consumeRequestQueue = (BlockingQueue)attributes[1];
        ThreadPoolExecutor consumeExecutor = (ThreadPoolExecutor)attributes[2];
        int consumeRequestQueueSize = consumeRequestQueue.size();
        Integer maxQueueSize = (Integer)TransformAccessUtils.getFromLopsAttributeMap((Object)service, (String)"maxConsumeRequestQueueSize");
        int maxConsumeRequestQueueSize = maxQueueSize == null ? 0 : maxQueueSize;
        int poolActiveThreadCount = consumeExecutor.getActiveCount();
        int maxConsumingPoolSize = consumeExecutor.getMaximumPoolSize();
        row.put((Object)"clientId", (Object)clientId);
        row.put((Object)"group", (Object)group);
        row.put((Object)"pid", (Object)RocketMqPidMapper.getPid(clientId));
        row.put((Object)"currentConsumeRequestQueueSize", (Object)consumeRequestQueueSize);
        row.put((Object)"maxConsumeRequestQueueSize", (Object)maxConsumeRequestQueueSize);
        row.put((Object)"currentConsumingThreadCount", (Object)poolActiveThreadCount);
        row.put((Object)"maxConsumingPoolSize", (Object)maxConsumingPoolSize);
        return row;
    }

    public void clear() {
    }

    public void parseParameters(Map<String, String> parameters) {
    }

    public List<MonitorDataRow> harvest() {
        try {
            return this.getAllStatus();
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e);
            return null;
        }
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    public String getName() {
        return "consumeServicePool";
    }
}

