/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.api;

import com.lubanops.apm.bootstrap.api.JavassistAPI;
import com.lubanops.apm.core.utils.ClassPoolUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;

public class JavassistAPIImpl
implements JavassistAPI {
    public List<String> matchInterface(List<String> interfaceNames, byte[] classfileBuffer) {
        ArrayList<String> resultList = new ArrayList<String>();
        try {
            ClassPool pool = ClassPoolUtils.getClassPool();
            ByteArrayInputStream ins = new ByteArrayInputStream(classfileBuffer);
            CtClass cls = pool.makeClass((InputStream)ins);
            if (cls.isInterface() || cls.isAnnotation() || cls.isEnum() || cls.isArray()) {
                return resultList;
            }
            CtClass[] interfaces = cls.getInterfaces();
            for (String interfaceName : interfaceNames) {
                boolean result = this.getAllInterfaces(interfaces, interfaceName);
                if (!result) continue;
                resultList.add(interfaceName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resultList;
    }

    private boolean getAllInterfaces(CtClass[] interfaces, String name) throws NotFoundException {
        for (CtClass interfaceObj : interfaces) {
            if (name.equals(interfaceObj.getName())) {
                return true;
            }
            boolean result = this.getAllInterfaces(interfaceObj.getInterfaces(), name);
            if (!result) continue;
            return result;
        }
        return false;
    }

    public boolean isRunnable(byte[] classfileBuffer) {
        try {
            ClassPool pool = ClassPoolUtils.getClassPool();
            ByteArrayInputStream ins = new ByteArrayInputStream(classfileBuffer);
            CtClass cls = pool.makeClass((InputStream)ins);
            if (cls.isInterface() || cls.isAnnotation() || cls.isEnum() || cls.isArray()) {
                return false;
            }
            try {
                cls.getDeclaredMethod("run", new CtClass[0]);
            }
            catch (NotFoundException e) {
                return false;
            }
            CtClass runnableClass = pool.get("java.lang.Runnable");
            CtClass serializableClass = pool.get("java.io.Serializable");
            boolean isSerializable = cls.subtypeOf(serializableClass);
            if (!isSerializable) {
                return cls.subtypeOf(runnableClass);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

