/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.kafka.collector.aggregator;

import com.lubanops.apm.bootstrap.api.APIService;
import com.lubanops.apm.bootstrap.api.InstrumentationManager;
import com.lubanops.apm.bootstrap.collector.api.AbstractPrimaryKeyValueAggregator;
import com.lubanops.apm.bootstrap.config.Stats;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlAggregator;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlStats;
import com.lubanops.apm.bootstrap.plugin.kafka.collector.aggregator.MethodPattern;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ConsumerMethodAggregator
extends UrlAggregator<UrlStats> {
    private static String tag_method = "method";
    private List<MethodPattern> methodPatterns = new ArrayList<MethodPattern>();

    public void parseParameters(Map<String, String> parametersMap) {
        if (parametersMap == null) {
            parametersMap = new HashMap<String, String>();
        }
        Integer slowRequestThreshold = (Integer)ParameterParseUtil.getParameterValue(parametersMap, (String)"kafkaSlowRequestThreshold", Integer.class);
        this.setSlowRequestThreshold(slowRequestThreshold);
        Stats slowRequestTraceCountStats = (Stats)ParameterParseUtil.getParameterValue(parametersMap, (String)"kafkaSlowRequestTraceCountStats", Stats.class);
        this.setSlowRequestTraceCountStats(slowRequestTraceCountStats);
        Stats errorRequestTraceCounStats = (Stats)ParameterParseUtil.getParameterValue(parametersMap, (String)"kafkaErrorRequestTraceCounStats", Stats.class);
        this.setErrorRequestTraceCounStats(errorRequestTraceCounStats);
        Stats requestTranceCountStats = (Stats)ParameterParseUtil.getParameterValue(parametersMap, (String)"kafkaRequestTranceCountStats", Stats.class);
        this.setRequestTranceCountStats(requestTranceCountStats);
        int[] range = (int[])ParameterParseUtil.getParameterValue(parametersMap, (String)"kafkaRange", int[].class);
        if (range != null && range.length == 5) {
            this.setRanges(range);
        } else {
            this.setRanges(AbstractPrimaryKeyValueAggregator.getDefaultRanges());
        }
        List<MethodPattern> oldMethodPatterns = this.methodPatterns;
        String methodPatternsStr = parametersMap.get("kafkaMethodPatterns");
        this.methodPatterns = StringUtils.isBlank((String)methodPatternsStr) ? new ArrayList<MethodPattern>() : APIService.getJsonApi().parseList(methodPatternsStr, MethodPattern.class);
        if (InstrumentationManager.inst != null) {
            this.retransformClasses(oldMethodPatterns, this.methodPatterns);
        }
    }

    private void retransformClasses(List<MethodPattern> oldMethodPattern, List<MethodPattern> newMethodPattern) {
        try {
            Class[] loadedClasses;
            String className;
            int i;
            HashSet<String> classPatternsSet = new HashSet<String>();
            for (i = 0; i < newMethodPattern.size(); ++i) {
                className = newMethodPattern.get(i).getClassName();
                classPatternsSet.add(className);
            }
            for (i = 0; i < oldMethodPattern.size(); ++i) {
                className = oldMethodPattern.get(i).getClassName();
                classPatternsSet.add(className);
            }
            if (classPatternsSet.size() == 0) {
                return;
            }
            block4: for (Class loadedClass : loadedClasses = InstrumentationManager.inst.getAllLoadedClasses()) {
                String className2 = loadedClass.getName();
                if (className2.startsWith("com/lubanops/apm/bootstrap") || className2.startsWith("com/lubanops/apm/premain") || className2.startsWith("com/lubanops/apm/transformer") || !className2.startsWith("com") && !className2.startsWith("org") || className2.contains("$")) continue;
                for (String classPattern : classPatternsSet) {
                    if (!Pattern.matches(classPattern, className2)) continue;
                    InstrumentationManager.inst.retransformClasses(loadedClass);
                    continue block4;
                }
            }
        }
        catch (Throwable e) {
            LogFactory.getLogger().log(Level.SEVERE, "kafkamethod retransform failed", e);
        }
    }

    public String getUrlKey() {
        return tag_method;
    }

    protected int primaryKeyLength() {
        return 1;
    }

    protected List<String> primaryKey() {
        return Arrays.asList(tag_method);
    }

    protected Class<UrlStats> getValueType() {
        return UrlStats.class;
    }

    public Map<String, Object> onStart(String method) {
        HashMap<String, Object> collectorContext = new HashMap<String, Object>();
        UrlStats kafkaStatsBase = (UrlStats)this.getValue(new String[]{method});
        if (kafkaStatsBase != null) {
            long startTime = kafkaStatsBase.onStart();
            collectorContext.put("startTime", startTime);
            collectorContext.put("statsBase", kafkaStatsBase);
            return collectorContext;
        }
        return null;
    }

    public void onError(UrlStats kafkaStatsBase) {
        kafkaStatsBase.onError();
    }

    public void onFinally(UrlStats kafkaStatsBase, Long startTime) {
        long endTime = System.nanoTime();
        long useTime = endTime - startTime;
        kafkaStatsBase.onFinally(useTime);
    }

    public List<MethodPattern> getMethodPatterns() {
        return this.methodPatterns;
    }

    public void setMethodPatterns(List<MethodPattern> methodPatterns) {
        this.methodPatterns = methodPatterns;
    }

    public String getName() {
        return "consumer";
    }
}

