/*
 * Decompiled with CFR 0.152.
 */
package one.jfr.event;

import one.jfr.event.Event;

public class EventAggregator {
    private static final int INITIAL_CAPACITY = 1024;
    private final boolean threads;
    private final boolean total;
    private Event[] keys;
    private long[] values;
    private int size;

    public EventAggregator(boolean bl, boolean bl2) {
        this.threads = bl;
        this.total = bl2;
        this.keys = new Event[1024];
        this.values = new long[1024];
    }

    public void collect(Event event) {
        int n = this.keys.length - 1;
        int n2 = this.hashCode(event) & n;
        while (this.keys[n2] != null) {
            if (this.sameGroup(this.keys[n2], event)) {
                int n3 = n2;
                this.values[n3] = this.values[n3] + (this.total ? event.value() : 1L);
                return;
            }
            n2 = n2 + 1 & n;
        }
        this.keys[n2] = event;
        long l = this.values[n2] = this.total ? event.value() : 1L;
        if (++this.size * 2 > this.keys.length) {
            this.resize(this.keys.length * 2);
        }
    }

    public long getValue(Event event) {
        int n = this.keys.length - 1;
        int n2 = this.hashCode(event) & n;
        while (this.keys[n2] != null && !this.sameGroup(this.keys[n2], event)) {
            n2 = n2 + 1 & n;
        }
        return this.values[n2];
    }

    public void forEach(Visitor visitor) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            visitor.visit(this.keys[i], this.values[i]);
        }
    }

    private int hashCode(Event event) {
        return event.hashCode() + (this.threads ? event.tid * 31 : 0);
    }

    private boolean sameGroup(Event event, Event event2) {
        return event.stackTraceId == event2.stackTraceId && (!this.threads || event.tid == event2.tid) && event.sameGroup(event2);
    }

    private void resize(int n) {
        Event[] eventArray = new Event[n];
        long[] lArray = new long[n];
        int n2 = eventArray.length - 1;
        block0: for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            int n3 = this.hashCode(this.keys[i]) & n2;
            while (true) {
                if (eventArray[n3] == null) {
                    eventArray[n3] = this.keys[i];
                    lArray[n3] = this.values[i];
                    continue block0;
                }
                n3 = n3 + 1 & n2;
            }
        }
        this.keys = eventArray;
        this.values = lArray;
    }

    public static interface Visitor {
        public void visit(Event var1, long var2);
    }
}

