/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class FlameGraph {
    public static final byte FRAME_INTERPRETED = 0;
    public static final byte FRAME_JIT_COMPILED = 1;
    public static final byte FRAME_INLINED = 2;
    public static final byte FRAME_NATIVE = 3;
    public static final byte FRAME_CPP = 4;
    public static final byte FRAME_KERNEL = 5;
    public static final byte FRAME_C1_COMPILED = 6;
    private final Arguments args;
    private final Frame root = new Frame(3);
    private int depth;
    private long mintotal;

    public FlameGraph(Arguments arguments) {
        this.args = arguments;
    }

    public FlameGraph(String ... stringArray) {
        this(new Arguments(stringArray));
    }

    public void parse() throws IOException {
        this.parse(new InputStreamReader((InputStream)new FileInputStream(this.args.input), StandardCharsets.UTF_8));
    }

    public void parse(Reader reader) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.lastIndexOf(32);
                if (n <= 0) continue;
                String[] stringArray = string.substring(0, n).split(";");
                long l = Long.parseLong(string.substring(n + 1));
                this.addSample(stringArray, l);
            }
        }
    }

    public void addSample(String[] stringArray, long l) {
        if (this.excludeTrace(stringArray)) {
            return;
        }
        Frame frame = this.root;
        if (this.args.reverse) {
            int n = stringArray.length;
            while (--n >= this.args.skip) {
                frame = frame.addChild(stringArray[n], l);
            }
        } else {
            for (int i = this.args.skip; i < stringArray.length; ++i) {
                frame = frame.addChild(stringArray[i], l);
            }
        }
        frame.addLeaf(l);
        this.depth = Math.max(this.depth, stringArray.length);
    }

    public void dump() throws IOException {
        if (this.args.output == null) {
            this.dump(System.out);
        } else {
            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.args.output), 32768);
                 PrintStream printStream = new PrintStream((OutputStream)bufferedOutputStream, false, "UTF-8");){
                this.dump(printStream);
            }
        }
    }

    public void dump(PrintStream printStream) {
        this.mintotal = (long)((double)this.root.total * this.args.minwidth / 100.0);
        int n = this.mintotal > 1L ? this.root.depth(this.mintotal) : this.depth + 1;
        String string = FlameGraph.getResource("/flame.html");
        string = this.printTill(printStream, string, "/*height:*/300");
        printStream.print(Math.min(n * 16, Short.MAX_VALUE));
        string = this.printTill(printStream, string, "/*title:*/");
        printStream.print(this.args.title);
        string = this.printTill(printStream, string, "/*reverse:*/false");
        printStream.print(this.args.reverse);
        string = this.printTill(printStream, string, "/*depth:*/0");
        printStream.print(n);
        string = this.printTill(printStream, string, "/*frames:*/");
        this.printFrame(printStream, "all", this.root, 0, 0L);
        string = this.printTill(printStream, string, "/*highlight:*/");
        printStream.print(this.args.highlight != null ? "'" + FlameGraph.escape(this.args.highlight) + "'" : "");
        printStream.print(string);
    }

    private String printTill(PrintStream printStream, String string, String string2) {
        int n = string.indexOf(string2);
        printStream.print(string.substring(0, n));
        return string.substring(n + string2.length());
    }

    private void printFrame(PrintStream printStream, String string, Frame frame, int n, long l) {
        byte by = frame.getType();
        if (by == 5) {
            string = FlameGraph.stripSuffix(string);
        }
        if ((frame.inlined | frame.c1 | frame.interpreted) != 0L && frame.inlined < frame.total && frame.interpreted < frame.total) {
            printStream.println("f(" + n + "," + l + "," + frame.total + "," + by + ",'" + FlameGraph.escape(string) + "'," + frame.inlined + "," + frame.c1 + "," + frame.interpreted + ")");
        } else {
            printStream.println("f(" + n + "," + l + "," + frame.total + "," + by + ",'" + FlameGraph.escape(string) + "')");
        }
        l += frame.self;
        for (Map.Entry entry : frame.entrySet()) {
            Frame frame2 = (Frame)entry.getValue();
            if (frame2.total >= this.mintotal) {
                this.printFrame(printStream, (String)entry.getKey(), frame2, n + 1, l);
            }
            l += frame2.total;
        }
    }

    private boolean excludeTrace(String[] stringArray) {
        Pattern pattern = this.args.include;
        Pattern pattern2 = this.args.exclude;
        if (pattern == null && pattern2 == null) {
            return false;
        }
        for (String string : stringArray) {
            if (pattern2 != null && pattern2.matcher(string).matches()) {
                return true;
            }
            if (pattern == null || !pattern.matcher(string).matches()) continue;
            pattern = null;
            if (pattern2 == null) break;
        }
        return pattern != null;
    }

    static String stripSuffix(String string) {
        return string.substring(0, string.length() - 4);
    }

    static String escape(String string) {
        if (string.indexOf(92) >= 0) {
            string = string.replace("\\", "\\\\");
        }
        if (string.indexOf(39) >= 0) {
            string = string.replace("'", "\\'");
        }
        return string;
    }

    private static String getResource(String string) {
        String string2;
        block10: {
            InputStream inputStream = FlameGraph.class.getResourceAsStream(string);
            try {
                int n;
                if (inputStream == null) {
                    throw new IOException("No resource found");
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[65536];
                while ((n = inputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                string2 = byteArrayOutputStream.toString("UTF-8");
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Can't load resource with name " + string);
                }
            }
            inputStream.close();
        }
        return string2;
    }

    public static void main(String[] stringArray) throws IOException {
        Arguments arguments = new Arguments(stringArray);
        if (arguments.input == null) {
            System.out.println("Usage: java " + FlameGraph.class.getName() + " [options] input.collapsed [output.html]");
            System.out.println();
            System.out.println("Options:");
            System.out.println("  --title TITLE");
            System.out.println("  --reverse");
            System.out.println("  --minwidth PERCENT");
            System.out.println("  --skip FRAMES");
            System.out.println("  --include PATTERN");
            System.out.println("  --exclude PATTERN");
            System.out.println("  --highlight PATTERN");
            System.exit(1);
        }
        FlameGraph flameGraph = new FlameGraph(arguments);
        flameGraph.parse();
        flameGraph.dump();
    }

    static class Frame
    extends TreeMap<String, Frame> {
        final byte type;
        long total;
        long self;
        long inlined;
        long c1;
        long interpreted;

        Frame(byte by) {
            this.type = by;
        }

        byte getType() {
            if (this.inlined * 3L >= this.total) {
                return 2;
            }
            if (this.c1 * 2L >= this.total) {
                return 6;
            }
            if (this.interpreted * 2L >= this.total) {
                return 0;
            }
            return this.type;
        }

        private Frame getChild(String string, byte by) {
            Frame frame = (Frame)super.get(string);
            if (frame == null) {
                frame = new Frame(by);
                super.put(string, frame);
            }
            return frame;
        }

        Frame addChild(String string, long l) {
            Frame frame;
            this.total += l;
            if (string.endsWith("_[j]")) {
                frame = this.getChild(FlameGraph.stripSuffix(string), (byte)1);
            } else if (string.endsWith("_[i]")) {
                frame = this.getChild(FlameGraph.stripSuffix(string), (byte)1);
                frame.inlined += l;
            } else if (string.endsWith("_[k]")) {
                frame = this.getChild(string, (byte)5);
            } else if (string.endsWith("_[1]")) {
                frame = this.getChild(FlameGraph.stripSuffix(string), (byte)1);
                frame.c1 += l;
            } else if (string.endsWith("_[0]")) {
                frame = this.getChild(FlameGraph.stripSuffix(string), (byte)1);
                frame.interpreted += l;
            } else {
                frame = string.contains("::") || string.startsWith("-[") || string.startsWith("+[") ? this.getChild(string, (byte)4) : (string.indexOf(47) > 0 && string.charAt(0) != '[' || string.indexOf(46) > 0 && Character.isUpperCase(string.charAt(0)) ? this.getChild(string, (byte)1) : this.getChild(string, (byte)3));
            }
            return frame;
        }

        void addLeaf(long l) {
            this.total += l;
            this.self += l;
        }

        int depth(long l) {
            int n = 0;
            if (this.size() > 0) {
                for (Frame frame : this.values()) {
                    if (frame.total < l) continue;
                    n = Math.max(n, frame.depth(l));
                }
            }
            return n + 1;
        }
    }
}

