/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mysql8.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlTrace;
import com.lubanops.apm.plugin.mysql8.interceptor.PreparedStatementInteceptor;
import com.mysql.cj.jdbc.StatementImpl;

public class StatementExecuteUpdateInterceptor
implements Interceptor {
    public Object[] onStart(Object mysql8Object, Object[] args, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                StatementImpl statement = (StatementImpl)mysql8Object;
                String mysql8Sql = (String)args[0];
                Integer id = PreparedStatementInteceptor.getConnectionId(statement);
                PreparedStatementInteceptor.onStart(mysql8Sql, id);
                MysqlTrace.onStart((String)className, (String)methodName, (String)mysql8Sql, (String)mysql8Sql, (Integer)id);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
        return new Object[0];
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                String sql = (String)args[0];
                Integer updateCount = Integer.valueOf(String.valueOf(result));
                MysqlCollector.onFinally((int)updateCount, (int)0);
                MysqlTrace.onFinally((int)updateCount, (int)0, null);
                MysqlCollector.onConnectionEnd((String)sql, (int)updateCount, (int)0);
            }
        }
        catch (Exception exception) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)exception);
        }
    }

    public void onError(Object object, Object[] args, Throwable throwable, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                String sql = (String)args[0];
                PreparedStatementInteceptor.onError(sql, throwable);
                MysqlTrace.onError((Throwable)throwable);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "StatementExecuteUpdateInterceptor onError", (Throwable)ex);
        }
    }
}

