/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.hbase.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.hbase.collector.HBaseCollector;

public class CallBlockingMethodInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (HBaseCollector.INSTANCE.isEnable()) {
                String serverAddr = args[5].toString();
                TraceCollector.onStart((String)className, (String)methodName, (String)"HBase");
                HBaseCollector.rpcCallOnStart(serverAddr);
            }
        }
        catch (Exception callException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)callException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (HBaseCollector.INSTANCE.isEnable()) {
                TraceCollector.onError((Throwable)e);
                HBaseCollector.rpcCallOnError(TraceCollector.getTraceId());
                HBaseCollector.onException(e);
            }
        }
        catch (Exception callException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)callException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (HBaseCollector.INSTANCE.isEnable()) {
                SpanEvent spanEvent = TraceCollector.getSpanEvent();
                String serverAddr = args[5].toString();
                if (spanEvent != null) {
                    spanEvent.addTag("Server Address", serverAddr);
                }
                TraceCollector.onFinally();
                HBaseCollector.rpcCallOnFinally();
            }
        }
        catch (Exception callException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)callException);
        }
    }
}

