/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.goldenDB.interceptor;

import com.goldendb.jdbc.StatementImpl;
import com.goldendb.jdbc.internal.core.io.ResultSetImpl;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.plugin.goldenDB.interceptor.PreparedStatementInteceptor;
import com.lubanops.apm.plugin.goldenDB.util.GoldenDBTrace;
import java.sql.SQLException;

public class StatementExecuteInterceptor
implements Interceptor {
    public Object[] onStart(Object statementObject, Object[] args, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                StatementImpl statement = (StatementImpl)statementObject;
                String originsql = (String)args[0];
                Integer id = PreparedStatementInteceptor.getConnectionId(statement);
                PreparedStatementInteceptor.onStart(originsql, id);
                GoldenDBTrace.onStart(className, methodName, originsql, originsql, id);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "StatementExecuteInterceptor onStart error", (Throwable)ex);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                String sql = (String)args[0];
                PreparedStatementInteceptor.onError(sql, e);
                GoldenDBTrace.onError(e);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "StatementExecuteInterceptor onError", (Throwable)ex);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        block7: {
            try {
                if (!MysqlCollector.INSTANCE.isEnable()) break block7;
                StatementImpl mysql8Statement = (StatementImpl)object;
                String sql = (String)args[0];
                int updatedRowCount = 0;
                ResultSetImpl mysql8ResultSet = null;
                int readRowCount = 0;
                try {
                    updatedRowCount = mysql8Statement.getUpdateCount();
                    mysql8ResultSet = (ResultSetImpl)mysql8Statement.getResultSet();
                    if (mysql8ResultSet != null) {
                        readRowCount = mysql8ResultSet.getRow();
                    }
                }
                catch (SQLException ex) {
                    LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
                }
                MysqlCollector.onFinally((int)updatedRowCount, (int)readRowCount);
                if (mysql8ResultSet != null && mysql8ResultSet instanceof TransformAccess) {
                    GoldenDBTrace.onFinally(updatedRowCount, readRowCount, (TransformAccess)mysql8ResultSet);
                } else {
                    GoldenDBTrace.onFinally(updatedRowCount, readRowCount, null);
                }
                MysqlCollector.onConnectionEnd((String)sql, (int)updatedRowCount, (int)readRowCount);
            }
            catch (Exception ex) {
                LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
            }
        }
    }
}

