/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.spring.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.otel.OtelSpanKind;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.spring.collector.SpringBeanMethodCollector;

public class SpringBeansInterceptor
implements Interceptor {
    private static final Logger LOGGER = LogFactory.getLogger();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (SpringBeanMethodCollector.INSTANCE.isEnable()) {
                String otelSpanName = object.getClass().getSimpleName() + "." + methodName;
                TraceCollector.onStart((String)className, (String)methodName, (String)"SpringBean", (String)otelSpanName, (OtelSpanKind)OtelSpanKind.INTERNAL);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "JavaMethodInterceptor onStart", (Throwable)e);
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (SpringBeanMethodCollector.INSTANCE.isEnable()) {
                TraceCollector.onError((Throwable)e);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "JavaMethodInterceptor onError", (Throwable)ex);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (SpringBeanMethodCollector.INSTANCE.isEnable()) {
                TraceCollector.onFinally();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "JavaMethodInterceptor onFinally", (Throwable)e);
        }
    }
}

