/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.grpc.server.collector;

import com.lubanops.apm.bootstrap.collector.api.AbstractPrimaryKeyValueAggregator;
import com.lubanops.apm.bootstrap.config.Stats;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlAggregator;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlSlowRequestThreshold;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlStats;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServerAggregator
extends UrlAggregator<UrlStats> {
    private static String tag_method = "method";

    public String getName() {
        return "detail";
    }

    protected List<String> primaryKey() {
        return Arrays.asList(tag_method);
    }

    public void parseParameters(Map<String, String> parametersMap) {
        if (parametersMap == null) {
            parametersMap = new HashMap<String, String>();
        }
        Integer slowRequestThreshold = (Integer)ParameterParseUtil.getParameterValue(parametersMap, (String)"GRPCServerSlowRequestThreshold", Integer.class);
        this.setSlowRequestThreshold(slowRequestThreshold);
        Stats slowRequestTraceCountStats = (Stats)ParameterParseUtil.getParameterValue(parametersMap, (String)"GRPCServerSlowRequestTraceCountStats", Stats.class);
        this.setSlowRequestTraceCountStats(slowRequestTraceCountStats);
        Stats errorRequestTraceCounStats = (Stats)ParameterParseUtil.getParameterValue(parametersMap, (String)"GRPCServerErrorRequestTraceCounStats", Stats.class);
        this.setErrorRequestTraceCounStats(errorRequestTraceCounStats);
        Stats requestTranceCountStats = (Stats)ParameterParseUtil.getParameterValue(parametersMap, (String)"GRPCServerRequestTranceCountStats", Stats.class);
        this.setRequestTranceCountStats(requestTranceCountStats);
        String sampType = (String)ParameterParseUtil.getParameterValue(parametersMap, (String)"GRPCServerSampleType", String.class);
        String percentage = (String)ParameterParseUtil.getParameterValue(parametersMap, (String)"GRPCServerPercentage", String.class);
        String periodCount = (String)ParameterParseUtil.getParameterValue(parametersMap, (String)"GRPCServerPeriodCount", String.class);
        this.getSampleConfig().setPercentage(percentage);
        this.getSampleConfig().setPeriodCount(periodCount);
        this.getSampleConfig().setSampleType(sampType);
        List urlSlowRequestThresholds = (List)ParameterParseUtil.getParameterValue(parametersMap, (String)"GRPCServerUrlSlowRequestThreshold", List.class, UrlSlowRequestThreshold.class);
        this.setUrlSlowRequestThresholds(urlSlowRequestThresholds);
        int[] range = (int[])ParameterParseUtil.getParameterValue(parametersMap, (String)"GRPCServerRange", int[].class);
        if (range != null && range.length == 5) {
            this.setRanges(range);
        } else {
            this.setRanges(AbstractPrimaryKeyValueAggregator.getDefaultRanges());
        }
    }

    protected Class<UrlStats> getValueType() {
        return UrlStats.class;
    }

    public Map<String, Object> onStart(String method) {
        HashMap<String, Object> collectorContext = new HashMap<String, Object>();
        UrlStats serverStatsBase = (UrlStats)this.getValue(new String[]{method});
        if (serverStatsBase != null) {
            long startTime = serverStatsBase.onStart();
            collectorContext.put("startTime", startTime);
            collectorContext.put("statsBase", serverStatsBase);
            return collectorContext;
        }
        return null;
    }

    public void onError(UrlStats serverStatsBase) {
        serverStatsBase.onError();
    }

    public void onFinally(UrlStats serverStatsBase, Long startTime) {
        long endTime = System.nanoTime();
        long useTime = endTime - startTime;
        serverStatsBase.onFinally(useTime);
    }

    public String getUrlKey() {
        return tag_method;
    }

    protected int primaryKeyLength() {
        return 1;
    }
}

