/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.reactornetty.client.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HttpClientCollector;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HttpClientType;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import io.netty.handler.codec.http.HttpHeaders;
import io.opentelemetry.api.trace.Span;
import java.util.HashMap;
import java.util.List;

public class HttpClientOperationsIpcInterceptor
implements Interceptor {
    private static final Logger LOGGER = LogFactory.getLogger();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        HttpHeaders httpHeaders = (HttpHeaders)args[0];
        if (httpHeaders instanceof TransformAccess) {
            SpanEvent spanEvent = (SpanEvent)((TransformAccess)httpHeaders).getLopsAttribute();
            ((TransformAccess)httpHeaders).setLopsAttribute(null);
            if (spanEvent != null) {
                TraceCollector.setSpanEvent((SpanEvent)spanEvent);
                spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)HttpClientType.Nettyclient.name());
                if (spanEvent != null) {
                    List txName;
                    String userFlag;
                    spanEvent.setAsync(true);
                    String nextSpanId = spanEvent.generateNextSpanId();
                    String traceId = spanEvent.getTraceId();
                    httpHeaders.set(Headers.TRACE_ID.getValue(), (Object)traceId);
                    String gTraceId = TraceCollector.getVirtualTraceId();
                    if (!StringUtils.isBlank((String)gTraceId)) {
                        httpHeaders.set(Headers.GTRACE_ID.getValue(), (Object)spanEvent.getGlobalTraceId());
                    }
                    httpHeaders.set(Headers.SPAN_ID.getValue(), (Object)nextSpanId);
                    httpHeaders.set(Headers.SOURCE_EVENT_ID.getValue(), (Object)spanEvent.getEventId());
                    if (spanEvent.hasSamplingPolicy()) {
                        httpHeaders.set(Headers.POLICY_ID.getValue(), (Object)spanEvent.getPolicyId());
                    }
                    if (!StringUtils.isBlank((String)(userFlag = TraceCollector.getUserFlag()))) {
                        httpHeaders.set(Headers.USER_FLAG.getValue(), (Object)userFlag);
                    }
                    if ((txName = TransactionCollector.getTxName()) != null && txName.size() > 0) {
                        httpHeaders.set(Headers.TXNANE_ID.getValue(), (Object)StringUtils.joinTxList((CharSequence)",", (List)txName));
                    }
                    httpHeaders.set(Headers.ENV_ID.getValue(), (Object)String.valueOf(IdentityConfigManager.getEnvId()));
                    httpHeaders.set(Headers.DOMAIN_ID.getValue(), (Object)String.valueOf(IdentityConfigManager.getDomainId()));
                    httpHeaders.set(Headers.DOMAIN_TYPE.getValue(), (Object)String.valueOf(IdentityConfigManager.getDomainType()));
                    HashMap<String, String> headers = new HashMap<String, String>();
                    TraceCollector.injectHeader(headers, (Span)spanEvent.getOtelSpan());
                    if (!headers.isEmpty()) {
                        headers.forEach((k, v) -> httpHeaders.set(k, v));
                    }
                }
            }
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String method) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (HttpClientCollector.INSTANCE.isEnable() && args[0] instanceof TransformAccess) {
                TraceCollector.G_TRACE_ID_THREAD_LOCAL.set(null);
                TraceCollector.USER_FLAG_THREAD_LOCAL.set(null);
                TraceCollector.POLICY_ID_THREAD_LOCAL.set(null);
                TransactionCollector.clear();
                TraceCollector.onFinally((int)200);
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }
}

