/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.view;

import com.taobao.arthas.core.command.model.CommandVO;
import com.taobao.arthas.core.command.model.HelpModel;
import com.taobao.arthas.core.command.view.ResultView;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.usage.StyledUsageFormatter;
import com.taobao.middleware.cli.CLI;
import com.taobao.text.Color;
import com.taobao.text.Decoration;
import com.taobao.text.Style;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.util.List;

public class HelpView
extends ResultView<HelpModel> {
    @Override
    public void draw(CommandProcess process, HelpModel result) {
        if (result.getCommands() != null) {
            String message = RenderUtil.render((Element)HelpView.mainHelp(result.getCommands()), (int)process.width());
            process.write(message);
        } else if (result.getDetailCommand() != null) {
            process.write(HelpView.commandHelp(result.getDetailCommand().cli(), process.width()));
        }
    }

    private static Element mainHelp(List<CommandVO> commands) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.row(new Element[]{new LabelElement("NAME").style(Style.style((Decoration)Decoration.bold)), new LabelElement("DESCRIPTION")});
        for (CommandVO commandVO : commands) {
            table.add(Element.row().add(new Element[]{Element.label((String)commandVO.getName()).style(Style.style((Color)Color.green))}).add(new Element[]{Element.label((String)commandVO.getSummary())}));
        }
        return table;
    }

    private static String commandHelp(CLI command, int width) {
        return StyledUsageFormatter.styledUsage(command, width);
    }
}

