/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.basic1000;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.command.model.CatModel;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.FileUtils;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;

@Name(value="cat")
@Summary(value="Concatenate and print files")
public class CatCommand
extends AnnotatedCommand {
    private static final Logger logger = LoggerFactory.getLogger(CatCommand.class);
    private List<String> files;
    private String encoding;
    private Integer sizeLimit = 131072;
    private int maxSizeLimit = 0x800000;

    @Argument(argName="files", index=0)
    @Description(value="files")
    public void setFiles(List<String> files) {
        this.files = files;
    }

    @Option(longName="encoding")
    @Description(value="File encoding")
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Option(shortName="M", longName="sizeLimit")
    @Description(value="Upper size limit in bytes for the result (128 * 1024 by default, the maximum value is 8 * 1024 * 1024)")
    public void setSizeLimit(Integer sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    @Override
    public void process(CommandProcess process) {
        File f;
        if (!this.verifyOptions(process)) {
            return;
        }
        for (String file : this.files) {
            f = new File(file);
            if (!f.exists()) {
                process.end(-1, "cat " + file + ": No such file or directory");
                return;
            }
            if (!f.isDirectory()) continue;
            process.end(-1, "cat " + file + ": Is a directory");
            return;
        }
        for (String file : this.files) {
            f = new File(file);
            if (f.length() > (long)this.sizeLimit.intValue()) {
                process.end(-1, "cat " + file + ": Is too large, size: " + f.length());
                return;
            }
            try {
                String fileToString = FileUtils.readFileToString(f, this.encoding == null ? Charset.defaultCharset() : Charset.forName(this.encoding));
                process.appendResult(new CatModel(file, fileToString));
            }
            catch (IOException e) {
                logger.error("cat read file error. name: " + file, (Throwable)e);
                process.end(1, "cat read file error: " + e.getMessage());
                return;
            }
        }
        process.end();
    }

    private boolean verifyOptions(CommandProcess process) {
        if (this.sizeLimit > this.maxSizeLimit) {
            process.end(-1, "sizeLimit cannot be large than: " + this.maxSizeLimit);
            return false;
        }
        int maxSizeLimitOfNonTty = 131072;
        if (!process.session().isTty() && this.sizeLimit > maxSizeLimitOfNonTty) {
            process.end(-1, "When executing in non-tty session, sizeLimit cannot be large than: " + maxSizeLimitOfNonTty);
            return false;
        }
        return true;
    }

    @Override
    public void complete(Completion completion) {
        if (!CompletionUtils.completeFilePath(completion)) {
            super.complete(completion);
        }
    }
}

