/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jetcd.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SampleFilter;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.jetcd.JetcdContext;
import com.lubanops.apm.plugin.jetcd.collector.JetcdCollector;
import com.lubanops.apm.plugin.jetcd.interceptor.JetcdElectionObserveSampleFilter;
import com.lubanops.apm.plugin.jetcd.interceptor.ResponseProcessHelper;
import io.etcd.jetcd.Election;
import io.etcd.jetcd.api.LeaderResponse;

public class ElectionObserverOnStreamInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (JetcdCollector.INSTANCE.isEnable()) {
                Election.Listener listener = (Election.Listener)((AttributeAccess)object).getLopsFileds()[0];
                String url = listener.getClass().getName() + "#" + methodName;
                JetcdCollector.onElectionObserveStart(url);
                SpanEvent preSpanEvent = TraceCollector.getSpanEvent();
                if (preSpanEvent != null) {
                    JetcdContext.SAVED_SPANEVENT_LOCAL.set(preSpanEvent);
                }
                StartTraceRequest startTraceRequest = new StartTraceRequest(className, methodName, null, null, null);
                startTraceRequest.setRealSource(url);
                startTraceRequest.setSource(url);
                startTraceRequest.setKind("Jetcd");
                startTraceRequest.setSampleFilter((SampleFilter)new JetcdElectionObserveSampleFilter());
                SpanEvent spanEvent = TraceCollector.onStart((StartTraceRequest)startTraceRequest);
                if (args.length >= 1 && args[0] instanceof LeaderResponse) {
                    ResponseProcessHelper.parseElectionResponseAndAddTag(args[0], spanEvent);
                } else if (args[0] instanceof Throwable) {
                    TraceCollector.onError((Throwable)((Throwable)args[0]));
                    JetcdCollector.onException((Throwable)args[0]);
                    JetcdContext.HAS_ERROR_LOCAL.set(Boolean.TRUE);
                }
            }
        }
        catch (Exception electionObserverOnStreamException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)electionObserverOnStreamException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (JetcdCollector.INSTANCE.isEnable()) {
                TraceCollector.onError((Throwable)e);
                JetcdCollector.onException(e);
                JetcdContext.HAS_ERROR_LOCAL.set(Boolean.TRUE);
            }
        }
        catch (Exception electionObserverOnStreamException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)electionObserverOnStreamException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (JetcdCollector.INSTANCE.isEnable()) {
                boolean isSuccess = !Boolean.TRUE.equals(JetcdContext.HAS_ERROR_LOCAL.get());
                SpanEvent spanEvent = TraceCollector.getSpanEvent();
                if (!isSuccess) {
                    JetcdCollector.onElectionObserveError(spanEvent == null ? null : spanEvent.getTraceId());
                }
                JetcdCollector.onElectionObserveFinally();
                TraceCollector.onFinally((int)(isSuccess ? 200 : 500));
                if (JetcdContext.SAVED_SPANEVENT_LOCAL.get() != null) {
                    TraceCollector.setSpanEvent((SpanEvent)JetcdContext.SAVED_SPANEVENT_LOCAL.get());
                }
                JetcdContext.SAVED_SPANEVENT_LOCAL.remove();
                JetcdContext.HAS_ERROR_LOCAL.remove();
            }
        }
        catch (Exception electionObserverOnStreamException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)electionObserverOnStreamException);
        }
    }
}

