/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jetcd.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.jetcd.JetcdContext;
import com.lubanops.apm.plugin.jetcd.JetcdServiceType;
import com.lubanops.apm.plugin.jetcd.collector.JetcdCollector;
import com.lubanops.apm.plugin.jetcd.interceptor.ResponseProcessHelper;
import java.util.Map;

public class Client05xOldExecutionInterceptor
implements Interceptor {
    private static final String METHOD_NAME = "execute";

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (JetcdCollector.INSTANCE.isEnable()) {
                TraceCollector.onStart((String)className, (String)METHOD_NAME, (String)"Jetcd");
            }
        }
        catch (Exception Client05xOldExecutionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)Client05xOldExecutionException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (JetcdCollector.INSTANCE.isEnable()) {
                Map<String, Object> context = JetcdContext.COLLECTOR_CONTEXT_LOCAL.get();
                JetcdCollector.onException(e);
                JetcdCollector.onRequestErrorAsync(context, TraceCollector.getTraceId());
                TraceCollector.onError((Throwable)e);
            }
        }
        catch (Exception Client05xOldExecutionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)Client05xOldExecutionException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (JetcdCollector.INSTANCE.isEnable()) {
                Map<String, Object> context = JetcdContext.COLLECTOR_CONTEXT_LOCAL.get();
                if (context != null) {
                    JetcdServiceType serviceType = (JetcdServiceType)((Object)context.get("serviceType"));
                    ResponseProcessHelper.parseAndProcessRequest(result, TraceCollector.getSpanEvent(), serviceType);
                    JetcdCollector.onRequestFinallyAsync(context, TraceCollector.getTraceId());
                }
                TraceCollector.onFinally();
                JetcdContext.COLLECTOR_CONTEXT_LOCAL.remove();
            }
        }
        catch (Exception Client05xOldExecutionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)Client05xOldExecutionException);
        }
    }
}

