/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.utils;

import java.util.Locale;

public class StemmingPolicyUtil {
    private static final String[] HTTP_METHOD = new String[]{"GET", "POST", "PUT", "DELETE", "HEAD", "CONNECT", "OPTIONS", "TRACE", "PATCH", "RPC"};
    private static final String TX_SEPARATOR = "_";

    public static boolean isTxTypeValid(String currTxType) {
        if (!currTxType.isEmpty()) {
            Locale local = Locale.getDefault();
            for (String httpMethod : HTTP_METHOD) {
                if (!currTxType.toUpperCase(local).startsWith(httpMethod)) continue;
                return true;
            }
        }
        return false;
    }

    public static String buildTxType(String httpMethod, String techBasedTxType) {
        if (techBasedTxType == null || techBasedTxType.isEmpty()) {
            return "";
        }
        return httpMethod + TX_SEPARATOR + techBasedTxType;
    }
}

