/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.kafka.producer;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.kafka.collector.KafkaHelper;
import java.util.Map;
import org.apache.kafka.clients.producer.ProducerConfig;

public class OverrideProducerIdInterceptor
implements Interceptor {
    private final ThreadLocal<Boolean> reformatClientIdLocal = new ThreadLocal();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            boolean needReformat;
            ProducerConfig config = (ProducerConfig)object;
            boolean bl = needReformat = !config.originals().containsKey("client.id") && config.getString("transactional.id") == null;
            if (needReformat) {
                this.reformatClientIdLocal.set(Boolean.TRUE);
            }
        }
        catch (Exception overrideProducerIdException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)overrideProducerIdException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            String redefinedId;
            int seqIdIndex;
            Map configs = (Map)args[0];
            Boolean needReformat = this.reformatClientIdLocal.get();
            if (Boolean.TRUE.equals(needReformat) && (seqIdIndex = (redefinedId = (String)configs.get("client.id")).indexOf("producer-")) >= 0) {
                int seqId = Integer.parseInt(redefinedId.substring(seqIdIndex += 9));
                KafkaHelper.PRODUCERINFO.addReformatIdSeq(redefinedId, String.valueOf(seqId));
            }
            this.reformatClientIdLocal.remove();
        }
        catch (Exception overrideProducerIdException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)overrideProducerIdException);
        }
    }
}

