/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.util;

import com.huawei.gaussdb.jdbc.util.GT;
import com.huawei.gaussdb.jdbc.util.PSQLException;
import com.huawei.gaussdb.jdbc.util.PSQLState;
import java.math.BigDecimal;

public class NumericConverter {
    private static final BigDecimal BIG_DECIMAL_MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal BIG_DECIMAL_MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal BIG_DECIMAL_MAX_INT = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal BIG_DECIMAL_MIN_INT = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal BIG_DECIMAL_MAX_SHORT = BigDecimal.valueOf(32767L);
    private static final BigDecimal BIG_DECIMAL_MIN_SHORT = BigDecimal.valueOf(-32768L);
    private static final BigDecimal BIG_DECIMAL_MAX_BYTE = BigDecimal.valueOf(127L);
    private static final BigDecimal BIG_DECIMAL_MIN_BYTE = BigDecimal.valueOf(-128L);
    private static final Long LONG_MAX_INT = Integer.MAX_VALUE;
    private static final Long LONG_MIN_INT = Integer.MIN_VALUE;
    private static final Long LONG_MAX_SHORT = 32767L;
    private static final Long LONG_MIN_SHORT = -32768L;
    private static final Long LONG_MAX_BYTE = 127L;
    private static final Long LONG_MIN_BYTE = -128L;
    private static final Integer INT_MAX_SHORT = Short.MAX_VALUE;
    private static final Integer INT_MIN_SHORT = Short.MIN_VALUE;
    private static final Integer INT_MAX_BYTE = 127;
    private static final Integer INT_MIN_BYTE = -128;

    public static long getLong(Object value) throws PSQLException {
        if (value == null) {
            return 0L;
        }
        if (value instanceof BigDecimal) {
            return NumericConverter.toLong((BigDecimal)value);
        }
        return (Long)value;
    }

    public static int getInt(Object value) throws PSQLException {
        if (value == null) {
            return 0;
        }
        if (value instanceof BigDecimal) {
            return NumericConverter.toInt((BigDecimal)value);
        }
        return (Integer)value;
    }

    public static short getShort(Object value) throws PSQLException {
        if (value == null) {
            return 0;
        }
        if (value instanceof BigDecimal) {
            return NumericConverter.toShort((BigDecimal)value);
        }
        return ((Integer)value).shortValue();
    }

    public static byte getByte(Object value) throws PSQLException {
        if (value == null) {
            return 0;
        }
        if (value instanceof BigDecimal) {
            return NumericConverter.toByte((BigDecimal)value);
        }
        return ((Integer)value).byteValue();
    }

    private static long toLong(BigDecimal value) throws PSQLException {
        if (value.compareTo(BIG_DECIMAL_MIN_LONG) >= 0 && value.compareTo(BIG_DECIMAL_MAX_LONG) <= 0) {
            return value.longValue();
        }
        throw new PSQLException(GT.tr("NUMERIC_VALUE_OUT_OF_RANGE", "long", value), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
    }

    private static int toInt(BigDecimal value) throws PSQLException {
        if (value.compareTo(BIG_DECIMAL_MIN_INT) >= 0 && value.compareTo(BIG_DECIMAL_MAX_INT) <= 0) {
            return value.intValue();
        }
        throw new PSQLException(GT.tr("NUMERIC_VALUE_OUT_OF_RANGE", "int", value), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
    }

    private static short toShort(BigDecimal value) throws PSQLException {
        if (value.compareTo(BIG_DECIMAL_MIN_SHORT) >= 0 && value.compareTo(BIG_DECIMAL_MAX_SHORT) <= 0) {
            return value.shortValue();
        }
        throw new PSQLException(GT.tr("NUMERIC_VALUE_OUT_OF_RANGE", "short", value), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
    }

    private static byte toByte(BigDecimal value) throws PSQLException {
        if (value.compareTo(BIG_DECIMAL_MIN_BYTE) >= 0 && value.compareTo(BIG_DECIMAL_MAX_BYTE) <= 0) {
            return value.byteValue();
        }
        throw new PSQLException(GT.tr("NUMERIC_VALUE_OUT_OF_RANGE", "byte", value), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
    }
}

