/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mongodb.collector;

import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.plugin.mongodb.stats.MongoClusterStats;
import java.util.List;
import java.util.Map;

public class MongoClusterAggregator
extends SinglePrimaryKeyAggregator<MongoClusterStats> {
    public static final String NODES = "nodes";
    private final ThreadLocal<Long> startTimeLocal = new ThreadLocal();
    private final ThreadLocal<MongoClusterStats> statsLocal = new ThreadLocal();
    private final ThreadLocal<Boolean> errorLocal = new ThreadLocal();
    private final ThreadLocal<String> nodesLocal = new ThreadLocal();

    public void parseParameters(Map<String, String> parameters) {
    }

    public void onStart(String clusterNodes) {
        if (!this.isEnable) {
            return;
        }
        MongoClusterStats stats = (MongoClusterStats)this.getValue(clusterNodes);
        long startTime = stats.onStart();
        this.statsLocal.set(stats);
        this.startTimeLocal.set(startTime);
        this.nodesLocal.set(clusterNodes);
    }

    public void onError(String errorTraceId) {
        if (!this.isEnable) {
            return;
        }
        MongoClusterStats stats = this.statsLocal.get();
        if (stats != null) {
            stats.onError(errorTraceId);
            this.errorLocal.set(Boolean.TRUE);
        }
    }

    public void onFinally() {
        if (!this.isEnable) {
            return;
        }
        MongoClusterStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        Boolean error = this.errorLocal.get();
        if (error == null) {
            error = Boolean.FALSE;
        }
        if (stats != null && startTime != null) {
            long timeUsed = System.nanoTime() - startTime;
            if (stats.onFinally(timeUsed)) {
                stats.setSlowTraceId(TraceCollector.getTraceId());
            }
            String nodes = this.nodesLocal.get();
            TransactionCollector.collect((long)timeUsed, (boolean)error, (String)String.valueOf(IdentityConfigManager.getEnvId()), (String)("MongoDB:" + nodes), (List)TransactionCollector.getTxName(), (String)"MongoDb");
        }
        this.statsLocal.set(null);
        this.startTimeLocal.set(null);
        this.errorLocal.set(null);
    }

    protected Class<MongoClusterStats> getValueType() {
        return MongoClusterStats.class;
    }

    public String getName() {
        return "cluster";
    }

    protected String primaryKey() {
        return NODES;
    }
}

