/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.collector.jvm;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.NonePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.plugin.collector.jvm.JVMAggregatorEnum;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;

public class JVMCompileAggregator
extends NonePrimaryKeyAggregator {
    private CompilationMXBean compilationMXBean;
    private long lastCompilationTime = 0L;

    JVMCompileAggregator() {
        try {
            this.compilationMXBean = ManagementFactory.getCompilationMXBean();
            if (this.compilationMXBean == null) {
                LogFactory.getLogger().log(Level.SEVERE, "compilationMXBean is null");
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "get compilationMXBean failed", (Throwable)e);
        }
    }

    public String getName() {
        return JVMAggregatorEnum.compile.name();
    }

    public void parseParameters(Map<String, String> parameters) {
    }

    public MonitorDataRow constructItemRow() {
        MonitorDataRow row = new MonitorDataRow(2);
        if (this.compilationMXBean != null) {
            long time = this.compilationMXBean.getTotalCompilationTime();
            row.put((Object)"compilationTime", (Object)(time - this.lastCompilationTime));
            row.put((Object)"totalCompilationTime", (Object)time);
            this.lastCompilationTime = time;
        }
        return row;
    }

    public boolean isCompilationTimeMonitoringSupported() {
        return this.compilationMXBean.isCompilationTimeMonitoringSupported();
    }

    public List<MonitorDataRow> getAllStatus() {
        return null;
    }

    public void clear() {
    }
}

